// Debug LED
sbit LED at LATA4_bit;

// LCD Ekran Baglantilari
sbit LCD_RS         at LATD7_bit;
sbit LCD_EN         at LATD6_bit;
sbit LCD_D4         at LATD5_bit;
sbit LCD_D5         at LATD4_bit;
sbit LCD_D6         at LATD3_bit;
sbit LCD_D7         at LATD2_bit;

sbit LCD_RS_Direction at TRISD7_bit;
sbit LCD_EN_Direction at TRISD6_bit;
sbit LCD_D7_Direction at TRISD5_bit;
sbit LCD_D6_Direction at TRISD4_bit;
sbit LCD_D5_Direction at TRISD3_bit;
sbit LCD_D4_Direction at TRISD2_bit;

void InitMCU(){
  // Giris-Cikis Secimleri
  TRISA=0b00000000;// [][][][LED][][][][]
  TRISB=0b00000000;// [][][][][][][][]
  TRISC=0b00000000;// [][][][][][][][]
  TRISD=0b00000000;// [LCD_RS][LCD_EN][LCD_D4][LCD_D5][LCD_D6][LCD_D7][][]
  TRISE=0b00000000;// [][][][][][][][]

  // Analog-Dijital Giris Secimleri
  ANSELA=0b00000000;// [][][][][][][][]
  ANSELB=0b00000000;// [][][][][][][][]
  ANSELC=0b00000000;// [][][][][][][][]
  ANSELD=0b00000000;// [][][][][][][][]
  ANSELE=0b00000000;// [][][][][][][][]

  // Port Temizleme
  LATA=0x00;
  LATB=0x00;
  LATC=0x00;
  LATD=0x00;
  LATE=0x00;

  // LCD Ekran Hazirlama
  Lcd_Init();
  Lcd_Cmd(_LCD_CURSOR_OFF);
  Lcd_Cmd(_LCD_CLEAR);
}

void main() {
  InitMCU();
  
  // Sonsuz Dng
  while(1){
    LCD_Out(1,1,"     TRUDYO     ");  // 1.satir 1.stuna "     TRUDYO     " yaz
    LCD_Out(2,1,"GELISTIRME KARTI");  // 2.satir 1.stuna "GELISTIRME KARTI" yaz
    
    delay_ms(2000);                   // 2 saniye bekleme
    Lcd_Cmd(_LCD_CLEAR);              // Tm ekrani temizle

    Lcd_Chr(2,3,'H'); delay_ms(100);  // 2.satir 3.stuna 'H' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('E');  delay_ms(100);  // Bir sonraki stuna 'E' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('L');  delay_ms(100);  // Bir sonraki stuna 'L' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('L');  delay_ms(100);  // Bir sonraki stuna 'L' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('O');  delay_ms(100);  // Bir sonraki stuna 'O' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP(' ');  delay_ms(100);  // Bir sonraki stuna ' ' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('W');  delay_ms(100);  // Bir sonraki stuna 'W' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('O');  delay_ms(100);  // Bir sonraki stuna 'O' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('R');  delay_ms(100);  // Bir sonraki stuna 'R' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('L');  delay_ms(100);  // Bir sonraki stuna 'L' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('D');  delay_ms(100);  // Bir sonraki stuna 'D' karakterini yaz ve 100ms bekle
    Lcd_Chr_CP('!');  delay_ms(5000); // Bir sonraki stuna '!' karakterini yaz ve 5 saniye bekle
  }
}